% Function, used to get relative bounded impulse responses
% Based on the work of Tom Holden's paper: http://www.dynare.org/wp-repo/dynarewp004.pdf

function IRF = GetRelBoundedIRF_both( VariableName, ShockName, alpha,TIRF )

    IRF = GetRelIRF( VariableName, ShockName,TIRF);
    TShadow = length( alpha )/2;
    Shadowi = zeros( TIRF, TShadow );
    Shadowe = zeros( TIRF, TShadow );
    for indx = 0:( TShadow - 1 )
        Shadowi( :, indx + 1 ) = GetRelIRF( VariableName, [ 'shadowImp_' sprintf( '%d', indx ) ] );
        Shadowe( :, indx + 1 ) = GetRelIRF( VariableName, [ 'shadowEnt_' sprintf( '%d', indx ) ] );
    end
    topalpha=alpha(1:TShadow);
    botalpha=alpha(1+TShadow:end);
    IRF = IRF + Shadowi*topalpha + Shadowe*botalpha;
end